<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_finder
 *
 * @copyright   (C) 2011 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\Finder\Administrator\View\Statistics;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Component\Finder\Administrator\Model\StatisticsModel;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Statistics view class for Finder.
 *
 * @since  2.5
 */
class HtmlView extends BaseHtmlView
{
    /**
     * The index statistics
     *
     * @var    \Joomla\CMS\Object\CMSObject
     *
     * @since  3.6.1
     */
    protected $data;

    /**
     * Method to display the view.
     *
     * @param   string  $tpl  A template file to load. [optional]
     *
     * @return  void
     *
     * @since   2.5
     */
    public function display($tpl = null)
    {
        /** @var StatisticsModel $model */
        $model = $this->getModel();
        $model->setUseExceptions(true);

        // Load the view data.
        $this->data = $model->getData();

        parent::display($tpl);
    }
}
